/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.JVMSystemConstants;
import java.io.Serializable;

public class TTLObject
implements Serializable {
    private static final long serialVersionUID = 464L;
    private Object myObject = null;
    long entryTime = 0L;
    static long DEFAULT_TTL = 4L;
    long myTTL;
    public static final int TTL_IN_HOURS = 0;
    public static final int TTL_IN_MIN = 1;
    public static final int TTL_IN_SEC = 2;

    private static long convertValuesFromUnitToMs(long value, int unit) {
        switch (unit) {
            case 0: {
                return value * 3600000L;
            }
            case 1: {
                return value * 60000L;
            }
            case 2: {
                return value * 1000L;
            }
        }
        return value;
    }

    protected static long getTTLFromSystemProperty(String systemProperty, long defaultTTL, int unit) {
        if (systemProperty != null) {
            try {
                String sTTL = JVMSystemConstants.GetPrivilegedSystemPropertyWithDefault(systemProperty, Long.toString(defaultTTL));
                if (sTTL != null) {
                    return TTLObject.convertValuesFromUnitToMs(Long.parseLong(sTTL), unit);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return TTLObject.convertValuesFromUnitToMs(defaultTTL, unit);
    }

    public Object getObject() {
        long now = System.currentTimeMillis();
        if (now - this.entryTime > this.myTTL) {
            this.myObject = null;
        }
        return this.myObject;
    }

    public void setObject(Object newObject) {
        this.entryTime = System.currentTimeMillis();
        this.myObject = newObject;
    }

    public TTLObject(Object anObject, String systemProperty) {
        this.init(anObject, systemProperty, DEFAULT_TTL, 0);
    }

    public TTLObject(Object anObject, String systemProperty, long defaultTTL, int unit) {
        this.init(anObject, systemProperty, defaultTTL, unit);
    }

    private void init(Object anObject, String systemProperty, long defaultTTL, int unit) {
        this.myObject = anObject;
        this.entryTime = System.currentTimeMillis();
        this.myTTL = TTLObject.getTTLFromSystemProperty(systemProperty, defaultTTL, unit);
    }
}

